/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class WitherFlowModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook {
    private static MobEffectInstance makeWitherEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19615_, 60 * level, level);
    }

    private static MobEffectInstance makeWeeknessEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19613_, 60 * level, level);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            LivingEntity target = context.getLivingTarget();
            LivingEntity attacker = context.getAttacker();
            if (target != null && target.m_6084_()) {
                int level = modifier.getLevel();
                target.m_7292_(WitherFlowModifier.makeWeeknessEffect(level));
                target.m_7292_(WitherFlowModifier.makeWitherEffect(level));
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(2 * level), (LivingEntity)attacker);
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_7292_(WitherFlowModifier.makeWeeknessEffect(modifier.getLevel()));
            target.m_7292_(WitherFlowModifier.makeWitherEffect(modifier.getLevel()));
        }
        return false;
    }
}

